;**************************************************************************************
; SOLAR CHARGE CONTROLLER-EFY WITH DIGITAL VOLTMETER-ADC0831+LCD+8051 
; By: ARUN KUMAR VADLA
;**************************************************************************************
$MOD51

; LCD 4-BIT MODE CONNECTIONS
RS    EQU    P1.7     ;LCD REGISTER SELECT LINE
EN    EQU    P1.6     ;LCD ENABLE LINE

DB4   EQU    P1.5     ;
DB5   EQU    P1.4     ;
DB6   EQU    P1.3     ;
DB7   EQU    P1.2     ;

; ADC0831 CONNECTIONS

CS  EQU P3.0
CLK EQU P3.1
DO  EQU P3.2

;INPUT & OUTPUT

DYI EQU P3.4      ; SOLAR PANEL VOLTAGE SENSOR
CHG_RL EQU P3.5   ; CHARGING CONTROL RELAY
LD_RL  EQU P3.7   ; LOAD CONTROL RELAY

DSEG

ORG 0020H

VAL1: DS 1
VAL2: DS 1
VAL3: DS 1
ADC_VAL: DS 1
BUF: DS 1
CNT1: DS 1
CNT2: DS 1
IMG: DS 1
FLAGS: DS 1
OCF BIT FLAGS.0  ; OVER CHARGE FLAG
LBF BIT FLAGS.1  ; LOW BATT FLAG


CSEG   

ORG 0000H

JMP MAIN

ORG 000BH	   ;Timer Interrupt0

JMP COUNTDOWN


MAIN: MOV SP,#50H
      MOV P3,#0FFH
      MOV P1,#0FFH
      CLR CHG_RL
      CLR LD_RL
      LCALL PWR_DELAY  
      LCALL INIT
      SETB CLK     
      SETB DO
      SETB CS
      SETB DYI
      MOV VAL1,#00H
      MOV VAL2,#00H
      MOV VAL3,#00H
      MOV FLAGS,#00H
      
      
      
LOADCHAR: MOV BUF,#40H
          LCALL CMD
      MOV DPTR,#RCHAR
REP:  CLR A
      MOVC A,@A+DPTR
      JZ SCREEN1
      MOV BUF,A
      LCALL DAT
      INC DPTR
      SJMP REP     
          
SCREEN1:     MOV BUF,#80H
             LCALL CMD
             MOV DPTR,#MSG1
       HERE: CLR A
             MOVC A,@A+DPTR
             JZ NEXT
             MOV BUF,A
             LCALL DAT
             INC DPTR
             SJMP HERE 

  NEXT: MOV BUF,#0C0H
        LCALL CMD
        MOV DPTR,#MSG2
 HERE1: CLR A
        MOVC A,@A+DPTR
        JZ OVER
        MOV BUF,A
        LCALL DAT
        INC DPTR
        SJMP HERE1

OVER:  LCALL ONE_SEC_DELAY
       LCALL ONE_SEC_DELAY
       LCALL CLEAR
       MOV BUF,#0C0H
       LCALL CMD
       MOV DPTR,#MSG7
 HERE2:CLR A
       MOVC A,@A+DPTR
       JZ CONVERT
       MOV BUF,A
       LCALL DAT
       INC DPTR
       SJMP HERE2



CONVERT: LCALL DDELAY
         CLR CS     ; INITIATE CONVERSION
         SETB CLK
         CLR CLK    ; FIRST CLOCK
         
         SETB CLK
         CLR CLK    ; SECOND CLOCK
         
         MOV A,#00H ; CLEAR A
         MOV R5,#08H ; 8 CLOCK PULSES
  AGAIN: MOV C,DO
         RLC A
         SETB CLK
         CLR CLK
         DJNZ R5,AGAIN
         SETB CS
         
                  
         MOV ADC_VAL,A
         MOV B,#79D   
         MUL AB       ; PRODUCT IN AB 
         MOV R1,B     ; HIGH BYTE IN B
         MOV R2,A     ; LOW BYTE IN A
       
         
         LCALL HEX2BCD
       
       MOV VAL1,R7
       MOV VAL2,R6
       MOV VAL3,R5 
       
       LCALL SENDVAL2LCD
              
CHECK: JNB LBF,CHECK2      ; SEE IF ANY FLAGS ARE SET ,i,e LOW BATT FLAG OR BATT FULL FLAG
       JB DYI,CONVERT
       
CHECK2:JNB OCF,PROCEED
       JB DYI,NIGHT
       SJMP CONVERT
       
PROCEED:JB DYI,NIGHT
       CLR LD_RL            ; OFF LOAD
       CLR LBF              ; CLEAR LOW BATT FLAG
       MOV A,VAL2           ; SEE IF BATT.IS FULL
       XRL A,#04H
       JZ FULLCHG
       CLR CHG_RL           ; CONNECT BATT. TO PANEL
       MOV DPTR,#MSG4       ; DISPLAY CHARGING MSG
       MOV IMG,#00H
       LCALL SENDSTAT2LCD
       LJMP CONVERT
       
FULLCHG: SETB OCF           ;SET OVERCHARGE FLAG
         SETB CHG_RL        ;DISCONNECT BATT.FROM PANEL
         MOV TH0,#03CH      ;START 5 MIN TIMER HERE
         MOV TL0,#0B0H      ;DISCONNECT BATT FROM PANEL
         MOV CNT1,#200D
         MOV CNT2,#30D   
         SETB ET0
         SETB TR0
         SETB EA
         MOV DPTR,#MSG5     ; DISPLAY BATT.FULL MSG
         MOV IMG,#01H
         LCALL SENDSTAT2LCD
         LJMP CONVERT
         

NIGHT: CLR CHG_RL      ; RECONNECT BATT. TO PANEL
       CLR TR0         ; STOP TIMER0 INCASE ITS RUNNING
       CLR OCF         ; CLEAR OVER CHARGE FLAG
       SETB LD_RL      ; CONNECT LOAD TO BATT.
       MOV A,VAL1
       XRL A,#00H
       JZ LOWBAT
       MOV DPTR,#MSG3   ; DISPLAY LOAD ON MSG
       MOV IMG,#02H
       LCALL SENDSTAT2LCD
       LJMP CONVERT
       
LOWBAT: SETB LBF
        CLR LD_RL       ; DISCONNECT LOAD FROM BATT.
        MOV DPTR,#MSG6  ; DISPLAY BAT.OW AND LOAD OFF MSG
        MOV IMG,#03H
        LCALL SENDSTAT2LCD
        LJMP CONVERT         
 
;****************************************************************************** 
 
 SENDVAL2LCD: 
              
              MOV BUF,#0C7H
              LCALL CMD
              
              MOV A,VAL1
              ORL A,#30H
              MOV BUF,A
              LCALL DAT
              
              MOV A,VAL2
              ORL A,#30H
              MOV BUF,A
              LCALL DAT
              
              MOV BUF,#'.'
              LCALL DAT
              
              MOV A,VAL3
              ORL A,#30H
              MOV BUF,A
              LCALL DAT
                           
              RET


;****************************************************************************** 
 
 SENDSTAT2LCD: MOV BUF,#080H
               LCALL CMD
        HERE3: CLR A
               MOVC A,@A+DPTR
               JZ PICT
               MOV BUF,A
               LCALL DAT
               INC DPTR
               SJMP HERE3
         
         PICT: MOV BUF,#0CEH
               LCALL CMD
               
               MOV BUF,IMG
               LCALL DAT                                           
         
         BACK: RET

;******************************************************************************               
;                     TIMER0 ISR  (5 MINUTES TIMER)
;****************************************************************************** 
 
 COUNTDOWN:
       CLR TR0
       MOV TH0,#03CH
       MOV TL0,#0B0H
       SETB TR0
       
       DJNZ CNT1,BACK2
       MOV CNT1,#200D
       DJNZ CNT2,BACK2
             
       CLR TR0           ; OFF 5 MIN TIMER
       CLR ET0
       CLR OCF           ; CLEAR OVER CHARGE FLAG
       CLR CHG_RL        ; RE-CONNECT BATT TO PANEL
       
BACK2: RETI
 
 
 ;******************************************************************************
Hex2BCD:        
        MOV R3,#00D
        MOV R4,#00D
        MOV R5,#00D
        MOV R6,#00D
        MOV R7,#00D
        ACALL H2B
        RET
        
H2B:	MOV B,#10D
        MOV A,R2
        DIV AB
        MOV   R3,B              ;   
        MOV   B,#10             ; R7,R6,R5,R4,R3
        DIV   AB
        MOV   R4,B
        MOV   R5,A
        CJNE R1,#00H,HIGH_BYTE   ; CHECK FOR HIGH BYTE
        SJMP ENDD
 
HIGH_BYTE:
MOV   A,#6
ADD   A,R3
MOV   B,#10
DIV   AB
MOV   R3,B
ADD   A,#5
ADD   A,R4
MOV   B,#10
DIV   AB
MOV   R4,B
ADD   A,#2
ADD   A,R5
MOV   B,#10
DIV   AB
MOV   R5,B
CJNE R6,#00D,ADD_IT
SJMP CONTINUE

ADD_IT:
        ADD A,R6
CONTINUE:
        MOV R6,A
        DJNZ R1,HIGH_BYTE
        MOV B, #10D
        MOV A,R6
        DIV AB
        MOV R6,B
        MOV R7,A
ENDD:   RET 

;************************************************************************************

ONE_SEC_DELAY:
                     
     	MOV R0,#10D    ; One second delay routine
RZ3: 	MOV R1,#100D
RZ1:	MOV R2,#250D
RZ2:	NOP
	NOP
	DJNZ R2,RZ2
	DJNZ R1,RZ1  
	DJNZ R0,RZ3  
        RET  
;************************************************************************************
	
PWR_DELAY:                       ; 15 mSec DELAY FOR LCD TO INTIALIZE AFTER POWER-ON
          MOV R4,#100D
H2:       MOV R3,#250D
H1:       DJNZ R3,H1
          DJNZ R4,H2
          RET
;********************LCD SUBROUTINES**************************************

CMD:     PUSH ACC        ; SAVE ACCUMULATOR 

         SETB EN
         CLR RS         ; SELECT SEND COMMAND
                   
         MOV A,BUF      ; PUT DATA BYTE IN ACC
         MOV C, ACC.4   ; LOAD HIGH NIBBLE ON DATA BUS
         MOV DB4,C      ; ONE BIT AT A TIME USING...
         MOV C, ACC.5   ; BIT MOVE OPERATOINS
         MOV DB5,C
         MOV C, ACC.6
         MOV DB6,C
         MOV C, ACC.7
         MOV DB7,C
         CLR EN
         NOP
         SETB EN        ; PULSE THE ENABLE LINE
         
         MOV C, ACC.0   ; SIMILARLY, LOAD LOW NIBBLE
         MOV DB4,C
         MOV C, ACC.1
         MOV DB5,C
         MOV C, ACC.2
         MOV DB6,C
         MOV C, ACC.3
         MOV DB7,C
         
         CLR EN
         NOP
         SETB EN      ; PULSE THE ENABLE LINE
                  
         LCALL MSDELAY
         
         POP ACC  
         RET
         

; ********************LCD SUBROUTINES**************************************

DAT:     PUSH ACC        ; SAVE ACCUMULATOR 

         SETB EN
         SETB RS         ; SELECT SEND DATA
         
         MOV A, BUF      ; PUT DATA BYTE IN ACC
         MOV C, ACC.4    ; LOAD HIGH NIBBLE ON DATA BUS
         MOV DB4,C       ; ONE BIT AT A TIME USING...
         MOV C, ACC.5    ; BIT MOVE OPERATOINS
         MOV DB5,C
         MOV C, ACC.6
         MOV DB6,C
         MOV C, ACC.7
         MOV DB7,C
        
         CLR EN
         NOP
         SETB EN          ; PULSE THE ENABLE LINE
         
         MOV C, ACC.0     ; SIMILARLY, LOAD LOW NIBBLE
         MOV DB4,C
         MOV C, ACC.1
         MOV DB5,C
         MOV C, ACC.2
         MOV DB6,C
         MOV C, ACC.3
         MOV DB7,C
              
         CLR EN
         NOP
         SETB EN         ; PULSE THE ENABLE LINENOP
         
         LCALL MSDELAY
         
         POP ACC          
         RET   
         
             
         
;********************LCD SUBROUTINES**************************************
CLEAR:  MOV BUF,#01H
        LCALL  CMD
        RET

;****************************LCD SUBROUTINES****************************************

DDELAY:  MOV R5,#41D            ; 4.1 mS DELAY
    QT2: MOV R6,#50D
    QT1: DJNZ R6,QT1
         DJNZ R5,QT2                 
         RET
;****************************LCD SUBROUTINES****************************************        
MSDELAY:  MOV R5,#26D               
    QT22: MOV R6,#50D
    QT11: DJNZ R6,QT11
          DJNZ R5,QT22                 
          RET
                        

;****************************LCD SUBROUTINES****************************************
        
INIT:    MOV BUF,#30H         ; FUNCTION SET - DATA BITS, LINES, FONTS
         LCALL CMD
         ACALL DDELAY         ;INITIAL DELAY 4.1MSEC
         
         MOV BUF,#30H         ; FUNCTION SET - DATA BITS, LINES, FONTS
         LCALL CMD
         ACALL DDELAY         ;INITIAL DELAY 4.1MSEC
         
         MOV BUF,#30H         ; FUNCTION SET - DATA BITS, LINES, FONTS
         LCALL CMD
         ACALL DDELAY         ;INITIAL DELAY 4.1MSEC
         
        
         MOV BUF,#28H         ;2 LINES 5X7, 4-BIT MODE 
         LCALL CMD
                  
         MOV BUF,#0CH         ; DISPLAY ON
         LCALL CMD
         
         MOV BUF,#01H         ; CLEAR DISPLAY, HOME CURSOR
         LCALL CMD
         
         MOV BUF,#06H         ; SET ENTRY MODE
         LCALL CMD            ; INCREMENT CURSOR RIGHT, NO SHIFT
                 
         RET          
;************************************************************************************
ORG 0320H
MSG1:
DB '  SOLAR CHARGE  ',00H
MSG2:
DB ' CONTROLLER-EFY ',00H
MSG3:
DB '     LOAD ON    ',00H
MSG4:
DB '    CHARGING    ',00H
MSG5:
DB '  BATTERY FULL  ',00H
MSG6:
DB 'BAT.LOW-LOAD OFF',00H
MSG7:
DB 'Volts: ',00H


ORG 0400H
RCHAR:
DB 04D,31D,17D,31D,17D,31D,17D,31D   ; CHARGING
DB 04D,31D,31D,31D,31D,31D,31D,31D   ; FULL
DB 31D,31D,14D,04D,04D,14D,31D,31D   ; LOAD
DB 04D,31D,17D,17D,17D,17D,17D,31D   ; LOW BATT
DB 31D,31D,31D,31D,31D,31D,31D,31D
DB 31D,31D,31D,31D,31D,31D,31D,31D
DB 31D,31D,31D,31D,31D,31D,31D,31D
DB 031D,31D,31D,31D,31D,31D,31D,31D,00H

END
         
 






